/*
 * Decompiled with CFR 0.152.
 */
package com.tusoni.RodDNA.installer.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class BootstrapJarClassLoader
extends ClassLoader {
    private String jarFile;
    private Hashtable htSizes = new Hashtable();
    private boolean executingFromJar = false;
    private Hashtable metaJarContent = new Hashtable();
    private String jarJarFile;
    private Manifest metaManifest = null;

    public static void main(String[] argv) {
        String arg = "sample.conf";
        if (argv.length > 0) {
            arg = argv[0];
        }
        String[] args = new String[]{arg};
        try {
            BootstrapJarClassLoader jcl = new BootstrapJarClassLoader("RodDNAInstaller.jar");
            jcl.invokeClass("com.tusoni.RodDNA.installer.RodDNAInstaller", args);
        }
        catch (ClassNotFoundException e) {
            System.err.println("1 Class not found: " + e);
        }
        catch (NoSuchMethodException e) {
            System.err.println("1 Class does not define a 'main' method: " + e);
        }
        catch (InvocationTargetException e) {
            System.err.println("1 Invoke excpt: " + e);
            System.err.println("1 Invoke excpt: " + e.getTargetException());
        }
    }

    public String getActualJarName() {
        if (this.executingFromJar) {
            return this.jarJarFile;
        }
        return this.jarFile;
    }

    public BootstrapJarClassLoader(String jFile) {
        this.jarFile = jFile;
        try {
            URL u = this.getClass().getResource("/" + this.jarFile);
            URLConnection uc = u.openConnection();
            if (uc instanceof JarURLConnection) {
                this.executingFromJar = true;
                JarURLConnection juc = (JarURLConnection)uc;
                this.jarJarFile = URLDecoder.decode(this.jarFile);
                this.jarFile = juc.getJarFileURL().getFile();
                this.jarFile = URLDecoder.decode(this.jarFile);
                this.initTopJarSizes();
                this.readJarInJar();
            } else {
                this.executingFromJar = false;
                this.initTopJarSizes();
            }
        }
        catch (IOException ioe) {
            System.err.println("Error getting file from file" + this.jarFile + ":" + ioe);
            this.jarFile = "";
        }
    }

    private void readJarInJar() {
        try {
            byte[] jarE = this.readBytesFromTopJar(this.jarJarFile);
            String tmpDir = System.getProperty("java.io.tmpdir");
            File jarInJarFile = new File(tmpDir, this.jarJarFile);
            FileOutputStream fout = new FileOutputStream(jarInJarFile.getCanonicalPath());
            for (int i = 0; i < jarE.length; ++i) {
                fout.write(jarE[i]);
            }
            fout.close();
            fout = null;
            Hashtable<String, Integer> sizes = new Hashtable<String, Integer>();
            JarFile jf = new JarFile(jarInJarFile);
            try {
                Enumeration<JarEntry> e = jf.entries();
                while (e.hasMoreElements()) {
                    JarEntry ze = e.nextElement();
                    sizes.put(ze.getName(), new Integer((int)ze.getSize()));
                }
                this.metaManifest = jf.getManifest();
                jf.close();
            }
            catch (IOException ioe) {
                System.err.println("Error reading sizes in '" + fout + "':" + ioe);
            }
            jarInJarFile.delete();
            ByteArrayInputStream bais = new ByteArrayInputStream(jarE);
            JarInputStream jis = new JarInputStream(bais);
            JarEntry je = null;
            while ((je = jis.getNextJarEntry()) != null) {
                if (je.isDirectory()) continue;
                int size = (int)je.getSize();
                if (size == -1) {
                    size = (Integer)sizes.get(je.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = jis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                this.metaJarContent.put(je.getName(), b);
            }
            jis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("ERROR:" + fnfe);
        }
        catch (IOException ioe) {
            System.err.println("ERROR:" + ioe);
        }
    }

    public String getMainClassName() {
        try {
            if (this.executingFromJar) {
                return this.metaManifest != null ? this.metaManifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS) : null;
            }
            JarFile jf = new JarFile(this.jarFile);
            Manifest mf = jf.getManifest();
            return mf != null ? mf.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS) : null;
        }
        catch (IOException ioe) {
            System.err.println("IOE getting main class " + ioe);
            return null;
        }
    }

    public void invokeClass(String name, String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = this.loadClass(name);
        Method m = c.getMethod("main", args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        String urlName = className.replace('.', '/') + ".class";
        byte[] b1 = null;
        b1 = this.executingFromJar ? (byte[])this.metaJarContent.get(urlName) : this.readBytesFromTopJar(urlName);
        if (b1 == null) {
            System.err.println("Class '" + className + "' not found.");
            return null;
        }
        try {
            return this.defineClass(className, b1, 0, b1.length);
        }
        catch (ClassFormatError cfe) {
            System.err.println("'" + className + "':" + cfe);
            return null;
        }
    }

    private void initTopJarSizes() {
        try {
            JarFile zf = new JarFile(this.jarFile);
            Enumeration<JarEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                JarEntry ze = e.nextElement();
                this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            zf.close();
        }
        catch (IOException ioe) {
            System.err.println("TOP Error reading sizes in '" + this.jarFile + "':" + ioe);
        }
    }

    public byte[] readBytesFromTopJar(String entryName) {
        try {
            JarInputStream zis = this.getTopJIS();
            JarEntry ze = null;
            while ((ze = zis.getNextJarEntry()) != null) {
                if (ze.isDirectory()) continue;
                int size = (int)ze.getSize();
                if (size == -1) {
                    size = (Integer)this.htSizes.get(ze.getName());
                }
                if (!ze.getName().equals(entryName)) continue;
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                zis.close();
                return b;
            }
            zis.close();
        }
        catch (NullPointerException e) {
            System.err.println("'" + this.jarFile + "':(done)" + e);
        }
        catch (FileNotFoundException e) {
            System.err.println("'" + this.jarFile + "':" + e);
        }
        catch (IOException e) {
            System.err.println("'" + this.jarFile + "':" + e);
        }
        return null;
    }

    private JarInputStream getTopJIS() {
        try {
            JarFile jf = new JarFile(this.jarFile);
            if (jf != null) {
                return new JarInputStream(new FileInputStream(this.jarFile));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR:" + e);
        }
        try {
            InputStream is = this.openResource(this.jarFile);
            return new JarInputStream(is);
        }
        catch (IOException io) {
            System.err.println("IOE:" + io);
            return null;
        }
    }

    private InputStream openResource(String filename) {
        try {
            InputStream is = BootstrapJarClassLoader.class.getResourceAsStream("/" + filename);
            is.available();
            return is;
        }
        catch (IOException e) {
            System.err.println("RM2: file not found:" + filename);
            System.exit(1);
        }
        catch (NullPointerException e2) {
            System.err.println("RM2: file not found!" + filename);
            e2.printStackTrace();
            System.exit(1);
        }
        return null;
    }
}

